/*
 * Decompiled with CFR 0.152.
 */
package com.djinfinite.manors_bounty.world.capability.entity;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;
import net.minecraftforge.common.util.INBTSerializable;

@AutoRegisterCapability
public class ModAttribute
implements INBTSerializable<CompoundTag> {
    private final HashMap<String, Integer> concurrentHashMap = new HashMap();
    private final ReentrantLock lock = new ReentrantLock();

    public synchronized int getCooldownValue(String key) {
        this.lock.lock();
        try {
            int n = this.concurrentHashMap.getOrDefault(key, 0);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public synchronized List<String> allKeys() {
        this.lock.lock();
        try {
            List<String> list = this.concurrentHashMap.keySet().stream().toList();
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    public synchronized void setCooldownValue(String key, int cd) {
        this.lock.lock();
        try {
            this.concurrentHashMap.put(key, cd);
        }
        finally {
            this.lock.unlock();
        }
    }

    public synchronized void removeCooldownValue(String key) {
        this.lock.lock();
        try {
            this.concurrentHashMap.remove(key);
        }
        finally {
            this.lock.unlock();
        }
    }

    public synchronized void clearCooldownValue() {
        this.lock.lock();
        try {
            this.concurrentHashMap.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.concurrentHashMap.forEach((arg_0, arg_1) -> ((CompoundTag)tag).m_128405_(arg_0, arg_1));
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        nbt.m_128431_().forEach(s -> this.concurrentHashMap.put((String)s, nbt.m_128451_(s)));
    }
}

